<x-user.content>
    <x-slot:title>eCommerce MM</x-slot:title>
    <x-slot:head>
        <style>
            a.btn_akun {
                /* border: 1px solid; */

                border-radius: 5px;
                text-align: left;
                padding: 13px;
                font-size: 20px;
                margin-bottom: 10px;
                color: black;
            }



            span.nol {
                position: relative;
                float: right;
                background-color: red;
                border-radius: 15px;
                padding: 5px;
                font-size: 13px;
                font-weight: bold;
                color: white;
            }

            .aktv {
                background-color: rgb(252, 220, 78);
                color: black !important;
            }

            .tgl {
                float: right;
                font-size: 12px;
            }


            .tracking-detail {
                padding: 3rem 0
            }

            #tracking {
                margin-bottom: 1rem
            }

            [class*=tracking-status-] p {
                margin: 0;
                font-size: 1.1rem;
                color: #fff;
                text-transform: uppercase;
                text-align: center
            }

            [class*=tracking-status-] {
                padding: 1.6rem 0
            }

            .tracking-status-intransit {
                background-color: #65aee0
            }

            .tracking-status-outfordelivery {
                background-color: #f5a551
            }

            .tracking-status-deliveryoffice {
                background-color: #f7dc6f
            }

            .tracking-status-delivered {
                background-color: #4cbb87
            }

            .tracking-status-attemptfail {
                background-color: #b789c7
            }

            .tracking-status-error,
            .tracking-status-exception {
                background-color: #d26759
            }

            .tracking-status-expired {
                background-color: #616e7d
            }

            .tracking-status-pending {
                background-color: #ccc
            }

            .tracking-status-inforeceived {
                background-color: #214977
            }

            .tracking-list {
                border: 1px solid #e5e5e5
            }

            .tracking-item {
                border-left: 1px solid #e5e5e5;
                position: relative;
                padding: 2rem 1.5rem .5rem 2.5rem;
                font-size: .9rem;
                margin-left: 3rem;
                min-height: 5rem
            }

            .tracking-item:last-child {
                padding-bottom: 4rem
            }

            .tracking-item .tracking-date {
                margin-bottom: .5rem
            }

            .tracking-item .tracking-date span {
                color: #888;
                font-size: 85%;
                padding-left: .4rem
            }

            .tracking-item .tracking-content {
                padding: .5rem .8rem;
                background-color: #f4f4f4;
                border-radius: .5rem
            }

            .tracking-item .tracking-content span {
                display: block;
                color: #888;
                font-size: 85%
            }

            .tracking-item .tracking-icon {
                line-height: 2.6rem;
                position: absolute;
                left: -1.3rem;
                width: 2.6rem;
                height: 2.6rem;
                text-align: center;
                border-radius: 50%;
                font-size: 1.1rem;
                background-color: #fff;
                color: #fff
            }

            .tracking-item .tracking-icon.status-sponsored {
                background-color: #f68
            }

            .tracking-item .tracking-icon.status-delivered {
                background-color: #4cbb87
            }

            .tracking-item .tracking-icon.status-outfordelivery {
                background-color: #f5a551
            }

            .tracking-item .tracking-icon.status-deliveryoffice {
                background-color: #f7dc6f
            }

            .tracking-item .tracking-icon.status-attemptfail {
                background-color: #b789c7
            }

            .tracking-item .tracking-icon.status-exception {
                background-color: #d26759
            }

            .tracking-item .tracking-icon.status-inforeceived {
                background-color: #214977
            }

            .tracking-item .tracking-icon.status-intransit {
                color: #e5e5e5;
                border: 1px solid #e5e5e5;
                font-size: .6rem
            }

            td.pro {
                line-height: 15px;
            }

            @media(min-width:992px) {
                .tracking-item {
                    margin-left: 10rem
                }

                .tracking-item .tracking-date {
                    position: absolute;
                    left: -10rem;
                    width: 7.5rem;
                    text-align: right
                }

                .tracking-item .tracking-date span {
                    display: block
                }

                .tracking-item .tracking-content {
                    padding: 0;
                    background-color: transparent
                }


            }
        </style>
    </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Akun</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row px-xl-5">


            <div class="col-lg-4">
                <div class="bg-light p-30 mb-5">
                    <div class="card card-widget widget-user">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <div class="justify-content-center d-flex mt-3">
                            @if (Auth::user()->kelamin_member == 'L')
                                <img class="rounded-circle shadow-4-strong" alt="avatar"
                                    style="border: 1px solid; width:40%"
                                    src="{{ asset('assets/admin/') }}/dist/img/avatar.png" />
                            @else
                                <img class="rounded-circle shadow-4-strong" alt="avatar2"
                                    style="border: 1px solid; width:40%"
                                    src="{{ asset('assets/admin/') }}/dist/img/avatar2.png" />
                            @endif

                        </div>
                        <div class="text-center mt-2">
                            <h6 class="mb-3">{{ Auth::user()->nm_member }} <br> ID Member :
                                {{ Auth::user()->kd_member }}
                            </h6>
                        </div>
                        <div class="card-footer">
                            <div class="row text-center">
                                <div class="col-sm-4 border-right">
                                    <div class="description-block">
                                        <h5 class="description-header">{{ poinmasuk(Auth::user()->id) }}</h5>
                                        <span class="description-text">JUMLAH POIN </span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-4 border-right">
                                    <div class="description-block">
                                        <h5 class="description-header">{{ poinkeluar(Auth::user()->id) }}</h5>
                                        <span class="description-text">TUKAR POIN</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                                <div class="col-sm-4">
                                    <div class="description-block">
                                        <h5 class="description-header">
                                            {{ poinmasuk(Auth::user()->id) - poinkeluar(Auth::user()->id) }}</h5>
                                        <span class="description-text">SISA POIN</span>
                                    </div>
                                    <!-- /.description-block -->
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                    </div>

                    <div class=" pt-3 pb-2">
                        <div class="">
                            <a href="/akun"
                                class="btn btn-block btn_akun {{ $data['menuOpen'] == 'akun' ? 'aktv' : '' }}">
                                <i class="fa fa-shopping-basket mr-2"></i>
                                Belanjaan
                                {{-- <span class="nol">10</span> --}}
                            </a>

                            <a href="/data-pembayaran"
                                class="btn btn-block btn_akun {{ $data['menuOpen'] == 'bayar' ? 'aktv' : '' }}">
                                <i class="fa fa-credit-card mr-2"></i>
                                Pembayaran
                                {{-- <span class="nol">10</span> --}}
                            </a>

                            {{-- <a href="" class="btn btn-block btn_akun">
                                <i class="fa fa-map-marker-alt mr-2"></i>
                                Alamat
                            </a> --}}
                            <hr>
                            <a href="/setting-akun"
                                class="btn btn-block btn_akun {{ $data['menuOpen'] == 'setting' ? 'aktv' : '' }}">
                                <i class="fa fa-cog mr-2"></i>
                                Setting Akun
                            </a>

                            <a href="/setting-password"
                                class="btn btn-block btn_akun {{ $data['menuOpen'] == 'password' ? 'aktv' : '' }}">
                                <i class="fa fa-key mr-2"></i>
                                Ubah Password
                            </a>

                            <a href="/logout-member" class="btn btn-block btn_akun">
                                <i class="fa fa-sign-out-alt mr-2"></i>
                                Log out
                            </a>
                        </div>



                    </div>

                </div>




            </div>

            <div class="col-lg-8">
                @if ($data['menuOpen'] == 'akun')
                    <div class="bg-light p-30 mb-5">
                        @forelse ($transaksi as $b)
                            <div class="card mb-3">
                                <div class="card-header">
                                    <span style="font-size: 13px;"> No. Order : #{{ $b->kd_transaksi }}</span>
                                    <span class="tgl">{{ tgl_inf($b->created_at) }}</span>
                                </div>

                                <div class="card-body">
                                    <div class="">

                                        <div class="d-flex justify-content-between">
                                            <p>Jml. Barang </p>
                                            <p>{{ item($b->id)->jml }} Item</p>
                                        </div>

                                        <div class="d-flex justify-content-between">
                                            <p>Subtotal</p>
                                            <p>Rp. {{ number_format($b->jumlah, 0, ',', '.') }}</p>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <p>Diskon</p>
                                            <p> {{ number_format($b->diskon, 0, ',', '.') }}%</p>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <p>Ongkir</p>
                                            <p>Rp. {{ number_format($b->ongkir, 0, ',', '.') }}</p>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <p>Total</p>
                                            <p>Rp. {{ number_format($b->total, 0, ',', '.') }}</p>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <button class="btn btn-success btn-block rounded mb-2"
                                                data-toggle="collapse" data-target="#status{{ $b->id }}">Status
                                                Pesanan</button>
                                        </div>
                                        <div class="col-md-6">
                                            <button class="btn btn-outline-dark rounded btn-block"
                                                data-toggle="collapse" data-target="#detail{{ $b->id }}">Detail
                                                Pesanan</button>
                                        </div>
                                    </div>

                                    {{-- status order --}}
                                    <div class="collapse mb-5 mt-3" id="status{{ $b->id }}">
                                        <div class="tracking-list">

                                            <div class="tracking-item">
                                                <div class="tracking-icon status-intransit">
                                                    <i class="fa fa-shopping-cart text-success"></i>
                                                    <!-- <i class="fas fa-circle"></i> -->
                                                </div>
                                                <div class="tracking-date">
                                                    {{ date('M d Y', strtotime($b->created_at)) }}<span>{{ date('H:i', strtotime($b->created_at)) }}</span>
                                                </div>
                                                <div class="tracking-content">Order Belajaan
                                                    <span>Status :
                                                        <b>{{ $b->sts_antar == 'N' ? 'AMBIL DITOKO' : 'DIANTARKAN' }}</b>
                                                        Menunggu proses pembayaran</span>
                                                </div>
                                            </div>

                                            @if ($b->pembayaran->tgl_bayar != null)
                                                <div class="tracking-item">
                                                    <div class="tracking-icon status-intransit">
                                                        <i class="fa fa-money-bill-alt text-success"></i>
                                                        <!-- <i class="fas fa-circle"></i> -->
                                                    </div>
                                                    <div class="tracking-date">
                                                        {{ date('M d Y', strtotime($b->pembayaran->tgl_bayar)) }}<span>{{ date('H:i', strtotime($b->pembayaran->tgl_bayar)) }}</span>
                                                    </div>
                                                    <div class="tracking-content">Transfer Pembayaran
                                                        <span>Menunggu konfirmasi pihak toko</span>
                                                    </div>
                                                </div>
                                            @endif
                                            @if ($b->pembayaran->sts_transfer == 'Y')
                                                <div class="tracking-item">
                                                    <div class="tracking-icon status-intransit">
                                                        <i class="fa fa-edit text-success"></i>
                                                        <!-- <i class="fas fa-circle"></i> -->
                                                    </div>
                                                    <div class="tracking-date">
                                                        {{ date('M d Y', strtotime($b->pembayaran->expired)) }}<span>{{ date('H:i', strtotime($b->pembayaran->expired)) }}</span>
                                                    </div>
                                                    <div class="tracking-content">Konfirmasi Pembayaran
                                                        <span>Proses pengemasan barang belanjaan,
                                                            @if ($b->sts_antar == 'N')
                                                                Jika sudah kami akan menghubungi anda.
                                                            @endif
                                                        </span>
                                                    </div>
                                                </div>
                                            @endif

                                        @empty(!$b->kurir)
                                            <div class="tracking-item">
                                                <div class="tracking-icon status-intransit">
                                                    <i class="fa fa-truck text-success"></i>
                                                    <!-- <i class="fas fa-circle"></i> -->
                                                </div>
                                                <div class="tracking-date">
                                                    {{ date('M d Y', strtotime($b->kurir->created_at)) }}<span>{{ date('H:i', strtotime($b->kurir->created_at)) }}</span>
                                                </div>
                                                <div class="tracking-content">Pengiriman Kerumah Anda
                                                    <span>Petugas Antar : {{ $b->kurir->karyawan->nm_karyawan }} HP :
                                                        {{ $b->kurir->karyawan->hp_karyawan }}</span>
                                                </div>
                                            </div>
                                        @endempty

                                        @if ($b->pembayaran->tgl_diterima != null)
                                            <div class="tracking-item">
                                                <div class="tracking-icon status-intransit">
                                                    <i class="fa fa-handshake text-success"></i>
                                                    <!-- <i class="fas fa-circle"></i> -->
                                                </div>
                                                <div class="tracking-date">
                                                    {{ date('M d Y', strtotime($b->pembayaran->tgl_diterima)) }}<span>{{ date('H:i', strtotime($b->pembayaran->tgl_diterima)) }}</span>
                                                </div>
                                                <div class="tracking-content">Sudah diterima
                                                    <span>Terimaksih telah berbelanja ditoko kami</span>
                                                </div>
                                            </div>
                                        @endif

                                    </div>
                                </div>


                                {{-- detail order --}}
                                <div class="collapse mb-5 mt-5" id="detail{{ $b->id }}">
                                    <div class="table-responsive">
                                        <table
                                            class="table table-light table-borderless table-hover text-center mb-0 dtl">
                                            <thead class="bg-warning">
                                                <tr>
                                                    <th colspan="2">Produk</th>
                                                    <th>Harga</th>
                                                    <th>Disc</th>
                                                    <th>Qty</th>

                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody class="align-middle">
                                                @foreach ($b->keranjang()->get() as $k)
                                                    <tr>
                                                        <td class="align-middle pro">
                                                            <img src="{{ asset('/storage/produk/' . $k->produk->gambar) }}"
                                                                alt="" style="width: 50px;">

                                                        </td>
                                                        <td class="text-left">
                                                            <small>{{ $k->produk->nm_produk }}</small>
                                                        </td>
                                                        <td class="align-middle">
                                                            <small>{{ number_format($k->harga, 0, ',', '.') }}</small>
                                                        </td>
                                                        <td class="align-middle">
                                                            <small>{{ number_format($k->diskon, 0, ',', '.') }}%</small>
                                                        </td>
                                                        <td class="align-middle">
                                                            <small>{{ $k->jumlah }}</small>
                                                        </td>

                                                        <td class="align-middle">
                                                            <small>{{ number_format($k->harga - (($k->harga * $k->diskon) / 100) * $k->jumlah, 0, ',', '.') }}</small>
                                                        </td>

                                                    </tr>
                                                @endforeach
                                                <tr>
                                                    <td colspan="5">Total</td>
                                                    <td>Rp. {{ number_format($b->jumlah, 0, ',', '.') }}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                            </div>
                        </div>
                    @empty
                    @endforelse
            @endif



            @if ($data['menuOpen'] == 'bayar')
                <div class="bg-light p-30 mb-5">
                    @forelse ($transaksi as $b)
                        <div class="card mb-3">
                            <div class="card-header">
                                <span style="font-size: 13px;"> No. Order : #{{ $b->kd_transaksi }}</span>
                                <span class="tgl">{{ tgl_inf($b->created_at) }}</span>
                            </div>

                            <div class="card-body">
                                <div class="">

                                    <div class="d-flex justify-content-between">
                                        <p>Jml. Barang </p>
                                        <p>{{ item($b->id)->jml }} Item</p>
                                    </div>

                                    <div class="d-flex justify-content-between">
                                        <p>Subtotal</p>
                                        <p>Rp. {{ number_format($b->jumlah, 0, ',', '.') }}</p>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <p>Diskon</p>
                                        <p> {{ number_format($b->diskon, 0, ',', '.') }}%</p>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <p>Ongkir</p>
                                        <p>Rp. {{ number_format($b->ongkir, 0, ',', '.') }}</p>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <p>Total</p>
                                        <p>Rp. {{ number_format($b->total, 0, ',', '.') }}</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <button class="btn btn-success btn-block rounded mb-2"
                                            data-toggle="collapse"
                                            data-target="#status{{ $b->id }}">Status
                                            Pesanan</button>
                                    </div>
                                    <div class="col-md-6">
                                        <button class="btn btn-outline-dark rounded btn-block"
                                            data-toggle="collapse"
                                            data-target="#detail{{ $b->id }}">Detail
                                            Pesanan</button>
                                    </div>
                                    @if ($b->pembayaran->sts_transfer == 'N')
                                        <div class="col-md-12 mt-3">
                                            <a href="/invoice/{{ $b->kd_transaksi }}"
                                                class="btn btn-primary btn-block btn-lg"><i
                                                    class="fa fa-hand-pointer mr-2"></i> Update Pembayaran</a>
                                        </div>
                                    @endif
                                </div>

                                {{-- status order --}}
                                <div class="collapse mb-5 mt-3" id="status{{ $b->id }}">
                                    <div class="tracking-list">

                                        <div class="tracking-item">
                                            <div class="tracking-icon status-intransit">
                                                <i class="fa fa-shopping-cart text-success"></i>
                                                <!-- <i class="fas fa-circle"></i> -->
                                            </div>
                                            <div class="tracking-date">
                                                {{ date('M d Y', strtotime($b->created_at)) }}<span>{{ date('H:i', strtotime($b->created_at)) }}</span>
                                            </div>
                                            <div class="tracking-content">Order Belajaan
                                                <span>Status :
                                                    <b>{{ $b->sts_antar == 'N' ? 'AMBIL DITOKO' : 'DIANTARKAN' }}</b>
                                                    Menunggu proses pembayaran</span>
                                            </div>
                                        </div>

                                        @if ($b->pembayaran->tgl_bayar != null)
                                            <div class="tracking-item">
                                                <div class="tracking-icon status-intransit">
                                                    <i class="fa fa-money-bill-alt text-success"></i>
                                                    <!-- <i class="fas fa-circle"></i> -->
                                                </div>
                                                <div class="tracking-date">
                                                    {{ date('M d Y', strtotime($b->pembayaran->tgl_bayar)) }}<span>{{ date('H:i', strtotime($b->pembayaran->tgl_bayar)) }}</span>
                                                </div>
                                                <div class="tracking-content">Transfer Pembayaran
                                                    <span>Menunggu konfirmasi pihak toko</span>
                                                </div>
                                            </div>
                                        @endif
                                        @if ($b->pembayaran->sts_transfer == 'Y')
                                            <div class="tracking-item">
                                                <div class="tracking-icon status-intransit">
                                                    <i class="fa fa-edit text-success"></i>
                                                    <!-- <i class="fas fa-circle"></i> -->
                                                </div>
                                                <div class="tracking-date">
                                                    {{ date('M d Y', strtotime($b->pembayaran->expired)) }}<span>{{ date('H:i', strtotime($b->pembayaran->expired)) }}</span>
                                                </div>
                                                <div class="tracking-content">Konfirmasi Pembayaran
                                                    <span>Proses pengemasan barang belanjaan,
                                                        @if ($b->sts_antar == 'N')
                                                            Jika sudah kami akan menghubungi anda.
                                                        @endif
                                                    </span>
                                                </div>
                                            </div>
                                        @endif

                                    @empty(!$b->kurir)
                                        <div class="tracking-item">
                                            <div class="tracking-icon status-intransit">
                                                <i class="fa fa-truck text-success"></i>
                                                <!-- <i class="fas fa-circle"></i> -->
                                            </div>
                                            <div class="tracking-date">
                                                {{ date('M d Y', strtotime($b->kurir->created_at)) }}<span>{{ date('H:i', strtotime($b->kurir->created_at)) }}</span>
                                            </div>
                                            <div class="tracking-content">Pengiriman Kerumah Anda
                                                <span>Petugas Antar : {{ $b->kurir->karyawan->nm_karyawan }} HP :
                                                    {{ $b->kurir->karyawan->hp_karyawan }}</span>
                                            </div>
                                        </div>
                                    @endempty

                                    @if ($b->pembayaran->tgl_diterima != null)
                                        <div class="tracking-item">
                                            <div class="tracking-icon status-intransit">
                                                <i class="fa fa-handshake text-success"></i>
                                                <!-- <i class="fas fa-circle"></i> -->
                                            </div>
                                            <div class="tracking-date">
                                                {{ date('M d Y', strtotime($b->pembayaran->tgl_diterima)) }}<span>{{ date('H:i', strtotime($b->pembayaran->tgl_diterima)) }}</span>
                                            </div>
                                            <div class="tracking-content">Sudah diterima
                                                <span>Terimaksih telah berbelanja ditoko kami</span>
                                            </div>
                                        </div>
                                    @endif

                                </div>
                            </div>


                            {{-- detail order --}}
                            <div class="collapse mb-5 mt-5" id="detail{{ $b->id }}">
                                <div class="table-responsive">
                                    <table
                                        class="table table-light table-borderless table-hover text-center mb-0 dtl">
                                        <thead class="bg-warning">
                                            <tr>
                                                <th colspan="2">Produk</th>
                                                <th>Harga</th>
                                                <th>Disc</th>
                                                <th>Qty</th>

                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody class="align-middle">
                                            @foreach ($b->keranjang()->get() as $k)
                                                <tr>
                                                    <td class="align-middle pro">
                                                        <img src="{{ asset('/storage/produk/' . $k->produk->gambar) }}"
                                                            alt="" style="width: 50px;">

                                                    </td>
                                                    <td class="text-left">
                                                        <small>{{ $k->produk->nm_produk }}</small>
                                                    </td>
                                                    <td class="align-middle">
                                                        <small>{{ number_format($k->harga, 0, ',', '.') }}</small>
                                                    </td>
                                                    <td class="align-middle">
                                                        <small>{{ number_format($k->diskon, 0, ',', '.') }}%</small>
                                                    </td>
                                                    <td class="align-middle">
                                                        <small>{{ $k->jumlah }}</small>
                                                    </td>

                                                    <td class="align-middle">
                                                        <small>{{ number_format($k->harga - (($k->harga * $k->diskon) / 100) * $k->jumlah, 0, ',', '.') }}</small>
                                                    </td>

                                                </tr>
                                            @endforeach
                                            <tr>
                                                <td colspan="5">Total</td>
                                                <td>Rp. {{ number_format($b->jumlah, 0, ',', '.') }}</td>
                                            </tr>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                @empty
                @endforelse
        @endif

        @if ($data['menuOpen'] == 'setting')
            <x-message></x-message>
            <div class="bg-light p-30 mb-5">
                <div class="card mb-3">
                    <div class="card-header">
                        Setting data akun
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <form action="{{ route('akun.update') }}" method="post">
                                @csrf

                                <label for="">Kode Member</label>
                                <input type="text" name="" id=""
                                    class="form-control mb-4" value="{{ $m->kd_member }}" readonly>

                                <label for="">Nama Lengkap</label>
                                <input type="text" name="nm_member" id="nama"
                                    class="form-control mb-4" value="{{ $m->nm_member }}">

                                <label for="">Jenis Kelamin</label>
                                <select name="kelamin" id="jns_kelamin" class="form-control mb-4">
                                    <option value="L" {{ $m->kelamin_member == 'L' ? 'selected' : '' }}>
                                        Laki-Laki</option>
                                    <option value="P" {{ $m->kelamin_member == 'P' ? 'selected' : '' }}>
                                        Perempuan
                                    </option>
                                </select>

                                <label for="">Email</label>
                                <input type="email" name="email_member" id="email"
                                    class="form-control mb-4" value="{{ $m->email_member }}">

                                <label for="">No HP</label>
                                <input type="text" name="hp_member" id="hp"
                                    class="form-control mb-4" value="{{ $m->hp_member }}">

                                <label for="">Username</label>
                                <input type="text" name="username" id="username"
                                    class="form-control mb-4" value="{{ $m->username }}">

                                <label for="">Masukan Password anda</label>
                                <input type="password" name="password" id="password"
                                    class="form-control mb-4" placeholder="Password" required>

                                <button class="btn btn-lg btn-primary btn-block"><i
                                        class="fa fa-save mr-2"></i>Simpan Perubahan</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endif


        @if ($data['menuOpen'] == 'password')
            <div class="bg-light p-30 mb-5">
                <x-message></x-message>
                <div class="card mb-3">
                    <div class="card-header">
                        Setting data akun
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <form action="{{ route('update.password') }}" method="post">
                                @csrf



                                <label for="">Username</label>
                                <input type="text" name="username" id="username"
                                    class="form-control mb-4" value="{{ $m->username }}" readonly>

                                <label for="">Masukan Password anda</label>
                                <input type="password" name="pass_lama" id="pass_lama"
                                    class="form-control mb-4" placeholder="Password lama" required>
                                @error('pass_lama')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror

                                <label for="">Masukan Password anda</label>
                                <input type="password" name="password" id="password"
                                    class="form-control mb-4" placeholder="Password Baru" required>
                                @error('password')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror

                                <label for="">Masukan Password anda</label>
                                <input type="password" name="password_confirmation"
                                    id="password_confirmation" class="form-control mb-4"
                                    placeholder="Password Baru" required>
                                @error('password_confirmation')
                                    <small class="text-danger mt-2">
                                        {{ $message }}
                                    </small>
                                @enderror

                                <button class="btn btn-lg btn-primary btn-block"><i
                                        class="fa fa-save mr-2"></i>Update Password</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        @endif








    </div>

    <div class="col-12">
        @if ($data['menuOpen'] == 'akun' || $data['menuOpen'] == 'bayar')
            {{ $transaksi->links('components.admin.pagination') }}
        @endif
        {{-- <nav>
            <ul class="pagination justify-content-center">
                <li class="page-item disabled"><a class="page-link" href="#">Previous</span></a>
                </li>
                <li class="page-item active"><a class="page-link" href="#">1</a></li>
                <li class="page-item"><a class="page-link" href="#">2</a></li>
                <li class="page-item"><a class="page-link" href="#">3</a></li>
                <li class="page-item"><a class="page-link" href="#">Next</a></li>
            </ul>
        </nav> --}}
    </div>


</div>




</div>
</div>



<x-slot:foot> </x-slot:foot>
</x-user.content>
